/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.arcticmobs;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.arcticmobs.CommonSubProxy;
import com.lycanitesmobs.arcticmobs.block.BlockFluidOoze;
import com.lycanitesmobs.arcticmobs.block.BlockFrostCloud;
import com.lycanitesmobs.arcticmobs.block.BlockFrostfire;
import com.lycanitesmobs.arcticmobs.block.BlockFrostweb;
import com.lycanitesmobs.arcticmobs.block.BlockIcefire;
import com.lycanitesmobs.arcticmobs.dispenser.DispenserBehaviorBlizzard;
import com.lycanitesmobs.arcticmobs.dispenser.DispenserBehaviorFrostbolt;
import com.lycanitesmobs.arcticmobs.dispenser.DispenserBehaviorFrostweb;
import com.lycanitesmobs.arcticmobs.dispenser.DispenserBehaviorIcefire;
import com.lycanitesmobs.arcticmobs.dispenser.DispenserBehaviorTundra;
import com.lycanitesmobs.arcticmobs.entity.EntityArix;
import com.lycanitesmobs.arcticmobs.entity.EntityBlizzard;
import com.lycanitesmobs.arcticmobs.entity.EntityFrostbolt;
import com.lycanitesmobs.arcticmobs.entity.EntityFrostweaver;
import com.lycanitesmobs.arcticmobs.entity.EntityFrostweb;
import com.lycanitesmobs.arcticmobs.entity.EntityIcefireball;
import com.lycanitesmobs.arcticmobs.entity.EntityMaug;
import com.lycanitesmobs.arcticmobs.entity.EntityReiver;
import com.lycanitesmobs.arcticmobs.entity.EntitySerpix;
import com.lycanitesmobs.arcticmobs.entity.EntityTundra;
import com.lycanitesmobs.arcticmobs.entity.EntityWendigo;
import com.lycanitesmobs.arcticmobs.entity.EntityYeti;
import com.lycanitesmobs.arcticmobs.item.ItemArcticEgg;
import com.lycanitesmobs.arcticmobs.item.ItemBlizzardCharge;
import com.lycanitesmobs.arcticmobs.item.ItemBucketOoze;
import com.lycanitesmobs.arcticmobs.item.ItemFrostboltCharge;
import com.lycanitesmobs.arcticmobs.item.ItemFrostwebCharge;
import com.lycanitesmobs.arcticmobs.item.ItemFrostyFur;
import com.lycanitesmobs.arcticmobs.item.ItemIcefireCharge;
import com.lycanitesmobs.arcticmobs.item.ItemScepterBlizzard;
import com.lycanitesmobs.arcticmobs.item.ItemScepterFrostbolt;
import com.lycanitesmobs.arcticmobs.item.ItemScepterFrostweb;
import com.lycanitesmobs.arcticmobs.item.ItemScepterIcefire;
import com.lycanitesmobs.arcticmobs.item.ItemScepterTundra;
import com.lycanitesmobs.arcticmobs.item.ItemTundraCharge;
import com.lycanitesmobs.arcticmobs.mobevent.MobEventSubZero;
import com.lycanitesmobs.arcticmobs.mobevent.MobEventWintersGrasp;
import com.lycanitesmobs.arcticmobs.worldgen.WorldGeneratorArctic;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.dispenser.DispenserBehaviorMobEggCustom;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.ItemInfo;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.item.ItemCustomFood;
import com.lycanitesmobs.core.item.ItemTreat;
import com.lycanitesmobs.core.mobevent.MobEventBase;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.spawning.SpawnTypeBase;
import com.lycanitesmobs.core.spawning.SpawnTypeLand;
import com.lycanitesmobs.core.spawning.SpawnTypeSky;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="arcticmobs", name="Lycanites Arctic Mobs", version="1.17.1.2 - MC 1.11.2", dependencies="required-after:lycanitesmobs", acceptedMinecraftVersions="[1.11.2]")
public class ArcticMobs {
    public static final String modid = "arcticmobs";
    public static final String name = "Lycanites Arctic Mobs";
    public static GroupInfo group;
    @Mod.Instance(value="arcticmobs")
    public static ArcticMobs instance;
    @SidedProxy(clientSide="com.lycanitesmobs.arcticmobs.ClientSubProxy", serverSide="com.lycanitesmobs.arcticmobs.CommonSubProxy")
    public static CommonSubProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        group = new GroupInfo(this, "Arctic Mobs", 6).setDimensionBlacklist("-1,1").setBiomes("COLD, SNOWY, CONIFEROUS, -END").setDungeonThemes("FROZEN, DUNGEON").setEggName("arcticspawn");
        group.loadFromConfig();
        ObjectManager.setCurrentGroup(group);
        AssetManager.addSound("ooze", group, "block.ooze");
        ObjectManager.addDamageSource("ooze", new DamageSource("ooze"));
        Fluid fluid = ObjectManager.addFluid("ooze");
        fluid.setLuminosity(10).setDensity(3000).setViscosity(5000).setTemperature(-1000);
        ObjectManager.addBlock("ooze", (Block)new BlockFluidOoze(fluid));
        ObjectManager.addItem("arcticspawn", new ItemArcticEgg());
        ObjectManager.addItem("yetimeatraw", (Item)new ItemCustomFood("yetimeatraw", group, 2, 0.5f, ItemCustomFood.FOOD_CLASS.RAW).setPotionEffect(MobEffects.field_76421_d, 45, 2, 0.8f));
        ObjectLists.addItem("rawmeat", ObjectManager.getItem("yetimeatraw"));
        OreDictionary.registerOre((String)"listAllporkraw", (Item)ObjectManager.getItem("yetimeatraw"));
        ObjectManager.addItem("yetimeatcooked", (Item)new ItemCustomFood("yetimeatcooked", group, 6, 0.7f, ItemCustomFood.FOOD_CLASS.COOKED).setPotionEffect(MobEffects.field_76429_m, 10, 2, 1.0f).setAlwaysEdible());
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("yetimeatcooked"));
        OreDictionary.registerOre((String)"listAllporkcooked", (Item)ObjectManager.getItem("yetimeatcooked"));
        ObjectManager.addItem("palesoup", new ItemCustomFood("palesoup", group, 6, 0.7f, ItemCustomFood.FOOD_CLASS.MEAL).setPotionEffect(MobEffects.field_76429_m, 60, 2, 1.0f).setAlwaysEdible().func_77625_d(16), 3, 1, 6);
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("palesoup"));
        ObjectManager.addItem("frostyfur", new ItemFrostyFur());
        ObjectManager.addItem("frostboltcharge", new ItemFrostboltCharge());
        ObjectManager.addItem("frostboltscepter", new ItemScepterFrostbolt(), 2, 1, 1);
        ObjectManager.addItem("frostwebcharge", new ItemFrostwebCharge());
        ObjectManager.addItem("frostwebscepter", new ItemScepterFrostweb(), 2, 1, 1);
        ObjectManager.addItem("tundracharge", new ItemTundraCharge());
        ObjectManager.addItem("tundrascepter", new ItemScepterTundra(), 2, 1, 1);
        ObjectManager.addItem("icefirecharge", new ItemIcefireCharge());
        ObjectManager.addItem("icefirescepter", new ItemScepterIcefire(), 2, 1, 1);
        ObjectManager.addItem("blizzardcharge", new ItemBlizzardCharge());
        ObjectManager.addItem("blizzardscepter", new ItemScepterBlizzard(), 2, 1, 1);
        ObjectManager.addItem("arixtreat", new ItemTreat("arixtreat", group));
        ObjectManager.addItem("serpixtreat", new ItemTreat("serpixtreat", group));
        ObjectManager.addItem("maugtreat", new ItemTreat("maugtreat", group));
        ObjectManager.addItem("bucketooze", new ItemBucketOoze(fluid).func_77642_a(Items.field_151133_ar));
        ObjectManager.addBlock("frostweb", new BlockFrostweb());
        AssetManager.addSound("frostcloud", group, "block.frostcloud");
        ObjectManager.addBlock("frostcloud", new BlockFrostCloud());
        AssetManager.addSound("frostfire", group, "block.frostfire");
        ObjectManager.addBlock("frostfire", new BlockFrostfire());
        AssetManager.addSound("icefire", group, "block.icefire");
        ObjectManager.addBlock("icefire", new BlockIcefire());
        BlockDispenser.field_149943_a.func_82595_a((Object)ObjectManager.getItem("arcticspawn"), (Object)new DispenserBehaviorMobEggCustom());
        MobInfo newMob = new MobInfo(group, "reiver", EntityReiver.class, 0xDDEEFF, 0x99DDEE).setPeaceful(false).setSummonable(true).setSummonCost(2).setDungeonLevel(0).addSubspecies(new Subspecies("ashen", "uncommon")).addSubspecies(new Subspecies("golden", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("FROSTFIRE, SKY").setBlockCost(8).setSpawnWeight(8).setAreaLimit(3).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "frostweaver", EntityFrostweaver.class, 0xAADDFF, 0x226699).setPeaceful(false).setSummonable(true).setSummonCost(2).setDungeonLevel(1).addSubspecies(new Subspecies("light", "uncommon")).addSubspecies(new Subspecies("azure", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(10).setAreaLimit(5).setGroupLimits(1, 2).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "yeti", EntityYeti.class, 0xEEEEFF, 153).setPeaceful(true).setSummonCost(2).setDungeonLevel(-1).addSubspecies(new Subspecies("russet", "uncommon")).addSubspecies(new Subspecies("violet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("CREATURE").setDespawn(false).setSpawnWeight(10).setAreaLimit(5).setGroupLimits(1, 4).setLightDark(true, false).setDungeonWeight(0);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "wendigo", EntityWendigo.class, 0xCCCCFF, 22015).setPeaceful(false).setSummonCost(8).setDungeonLevel(2).addSubspecies(new Subspecies("keppel", "uncommon")).addSubspecies(new Subspecies("violet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER, OOZE").setBlockCost(16).setSpawnWeight(4).setAreaLimit(1).setGroupLimits(1, 1).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "arix", EntityArix.class, 0xDDDDFF, 0x9999FF).setPeaceful(false).setTameable(true).setSummonCost(2).setDungeonLevel(1).addSubspecies(new Subspecies("azure", "uncommon")).addSubspecies(new Subspecies("violet", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("SKY, OOZE").setBlockCost(16).setSpawnWeight(8).setAreaLimit(3).setGroupLimits(1, 3).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "serpix", EntitySerpix.class, 0xCCEEFF, 187).setPeaceful(false).setTameable(true).setSummonCost(8).setDungeonLevel(2).addSubspecies(new Subspecies("azure", "uncommon")).addSubspecies(new Subspecies("verdant", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER, OOZE").setBlockCost(32).setSpawnWeight(4).setAreaLimit(1).setGroupLimits(1, 1).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        newMob = new MobInfo(group, "maug", EntityMaug.class, 0xC9CCCD, 5394510).setPeaceful(false).setTameable(true).setSummonCost(4).setDungeonLevel(1).addSubspecies(new Subspecies("russet", "uncommon")).addSubspecies(new Subspecies("dark", "uncommon"));
        newMob.spawnInfo.setSpawnTypes("MONSTER").setSpawnWeight(4).setAreaLimit(5).setGroupLimits(1, 2).setLightDark(false, true);
        ObjectManager.addMob(newMob);
        ObjectManager.addProjectile("frostbolt", EntityFrostbolt.class, ObjectManager.getItem("frostboltcharge"), new DispenserBehaviorFrostbolt());
        ObjectManager.addProjectile("frostweb", EntityFrostweb.class, ObjectManager.getItem("frostwebcharge"), new DispenserBehaviorFrostweb());
        ObjectManager.addProjectile("tundra", EntityTundra.class, ObjectManager.getItem("tundracharge"), new DispenserBehaviorTundra());
        ObjectManager.addProjectile("icefireball", EntityIcefireball.class, ObjectManager.getItem("icefirecharge"), new DispenserBehaviorIcefire());
        ObjectManager.addProjectile("blizzard", EntityBlizzard.class, ObjectManager.getItem("blizzardcharge"), new DispenserBehaviorBlizzard());
        proxy.registerModels(group);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MobInfo.loadAllFromConfigs(group);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ObjectManager.setCurrentGroup(group);
        ConfigBase config = ConfigBase.getConfig(group, "spawning");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorArctic(), (int)0);
        MobEventBase mobEvent = new MobEventSubZero("subzero", group);
        SpawnTypeBase eventSpawner = new SpawnTypeSky("subzero").setChance(1.0).setBlockLimit(32).setMobLimit(3);
        eventSpawner.materials = new Material[]{Material.field_151579_a};
        eventSpawner.ignoreBiome = true;
        eventSpawner.ignoreLight = true;
        eventSpawner.forceSpawning = true;
        eventSpawner.ignoreMobConditions = true;
        eventSpawner.addSpawn(MobInfo.getFromName("reiver"));
        mobEvent.addSpawner(eventSpawner);
        MobEventManager.instance.addWorldEvent(mobEvent);
        mobEvent = new MobEventWintersGrasp("wintersgrasp", group);
        mobEvent.minDay = 10;
        eventSpawner = new SpawnTypeLand("wintersgrasp").setChance(1.0).setBlockLimit(32).setMobLimit(3);
        eventSpawner.materials = new Material[]{Material.field_151579_a};
        eventSpawner.ignoreBiome = true;
        eventSpawner.ignoreLight = true;
        eventSpawner.forceSpawning = true;
        eventSpawner.ignoreMobConditions = true;
        eventSpawner.addSpawn(MobInfo.getFromName("wendigo"));
        eventSpawner.addSpawn(MobInfo.getFromName("serpix"), 2);
        mobEvent.addSpawner(eventSpawner);
        MobEventManager.instance.addWorldEvent(mobEvent);
        Biome[] biomes = ArcticMobs.group.biomes;
        if (ArcticMobs.group.controlVanillaSpawns) {
            EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.removeSpawn(EntityWitch.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ObjectManager.getItem("palesoup"), 1, 0), new Object[]{Items.field_151117_aB.func_77642_a(Items.field_151133_ar), Items.field_151054_z, ObjectManager.getItem("yetimeatcooked")}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(ObjectManager.getItem("yetimeatcooked"), 1, 0), new Object[]{ObjectManager.getItem("palesoup")}));
        if (ItemInfo.enableWeaponRecipes) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("frostboltscepter"), 1, 0), new Object[]{"CCC", "CRC", "CRC", Character.valueOf('C'), ObjectManager.getItem("frostboltcharge"), Character.valueOf('R'), Items.field_151072_bj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("frostwebscepter"), 1, 0), new Object[]{"CCC", "CRC", "CRC", Character.valueOf('C'), ObjectManager.getItem("frostwebcharge"), Character.valueOf('R'), Items.field_151072_bj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("tundrascepter"), 1, 0), new Object[]{"SCS", "SRS", "SRS", Character.valueOf('C'), ObjectManager.getItem("tundracharge"), Character.valueOf('S'), ObjectManager.getItem("frostyfur"), Character.valueOf('R'), Items.field_151072_bj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("icefirescepter"), 1, 0), new Object[]{"CCC", "CRC", "CRC", Character.valueOf('C'), ObjectManager.getItem("icefirecharge"), Character.valueOf('R'), Items.field_151072_bj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("blizzardscepter"), 1, 0), new Object[]{"CCC", "CRC", "CRC", Character.valueOf('C'), ObjectManager.getItem("blizzardcharge"), Character.valueOf('R'), Items.field_151072_bj}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("arixtreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), Blocks.field_150403_cj, Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("serpixtreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), ObjectManager.getItem("frostyfur"), Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ObjectManager.getItem("maugtreat"), 4, 0), new Object[]{"TTT", "BBT", "TTT", Character.valueOf('T'), ObjectManager.getItem("yetimeatcooked"), Character.valueOf('B'), Items.field_151103_aS}));
        GameRegistry.addSmelting((Item)ObjectManager.getItem("yetimeatraw"), (ItemStack)new ItemStack(ObjectManager.getItem("yetimeatcooked"), 1), (float)0.5f);
    }
}

